/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.AsteriskMapping;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.UserEventAction;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.manager.internal.ActionBuilder;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;

class ActionBuilderImpl
implements ActionBuilder {
    private static final String LINE_SEPARATOR = "\r\n";
    private static final String ATTRIBUTES_PROPERTY_NAME = "attributes";
    private final Log logger = LogFactory.getLog(this.getClass());
    private AsteriskVersion targetVersion;
    private final Set<String> membersToIgnore = new HashSet<String>();

    ActionBuilderImpl() {
        this.targetVersion = AsteriskVersion.ASTERISK_1_0;
        this.membersToIgnore.add("class");
        this.membersToIgnore.add("action");
        this.membersToIgnore.add("actionid");
        this.membersToIgnore.add(ATTRIBUTES_PROPERTY_NAME);
    }

    @Override
    public void setTargetVersion(AsteriskVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    @Override
    public String buildAction(ManagerAction action) {
        return this.buildAction(action, null);
    }

    @Override
    public String buildAction(ManagerAction action, String internalActionId) {
        Map<String, Method> getters;
        StringBuilder sb = new StringBuilder();
        sb.append("action: ");
        sb.append(action.getAction());
        sb.append(LINE_SEPARATOR);
        if (internalActionId != null) {
            sb.append("actionid: ");
            sb.append(ManagerUtil.addInternalActionId(action.getActionId(), internalActionId));
            sb.append(LINE_SEPARATOR);
        } else if (action.getActionId() != null) {
            sb.append("actionid: ");
            sb.append(action.getActionId());
            sb.append(LINE_SEPARATOR);
        }
        if (action instanceof UserEventAction) {
            UserEvent userEvent = ((UserEventAction)action).getUserEvent();
            this.appendUserEvent(sb, userEvent);
            getters = ReflectionUtil.getGetters(userEvent.getClass());
            this.appendGetters(sb, userEvent, getters);
        } else {
            getters = ReflectionUtil.getGetters(action.getClass());
            this.appendGetters(sb, action, getters);
        }
        if (getters.containsKey(ATTRIBUTES_PROPERTY_NAME)) {
            Method getter = getters.get(ATTRIBUTES_PROPERTY_NAME);
            Object value = null;
            try {
                value = getter.invoke((Object)action, new Object[0]);
            }
            catch (Exception ex) {
                this.logger.error("Unable to retrieve property 'attributes' of " + action.getClass(), ex);
            }
            if (value instanceof Map) {
                Map attributes = (Map)value;
                for (Map.Entry entry : attributes.entrySet()) {
                    this.appendString(sb, entry.getKey() == null ? "null" : entry.getKey().toString(), entry.getValue() == null ? "null" : entry.getValue().toString());
                }
            }
        }
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    private void appendMap(StringBuilder sb, String key, Map<String, String> values) {
        String singularKey = key.endsWith("s") ? key.substring(0, key.length() - 1) : key;
        if (this.targetVersion.isAtLeast(AsteriskVersion.ASTERISK_1_2)) {
            this.appendMap12(sb, singularKey, values);
        } else {
            this.appendMap10(sb, singularKey, values);
        }
    }

    private void appendMap10(StringBuilder sb, String singularKey, Map<String, String> values) {
        sb.append(singularKey);
        sb.append(": ");
        Iterator<Map.Entry<String, String>> entryIterator = values.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, String> entry = entryIterator.next();
            sb.append(entry.getKey());
            sb.append("=");
            if (entry.getValue() != null) {
                sb.append(entry.getValue());
            }
            if (!entryIterator.hasNext()) continue;
            sb.append("|");
        }
        sb.append(LINE_SEPARATOR);
    }

    private void appendMap12(StringBuilder sb, String singularKey, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            sb.append(singularKey);
            sb.append(": ");
            sb.append(entry.getKey());
            sb.append("=");
            if (entry.getValue() != null) {
                if (entry.getKey().equalsIgnoreCase("Content")) {
                    String[] sp = entry.getValue().split("\n");
                    if (sp.length > 0) {
                        sb.append(sp[0]);
                        for (int i = 1; i < sp.length; ++i) {
                            sb.append(LINE_SEPARATOR);
                            sb.append(singularKey);
                            sb.append(": ");
                            sb.append(entry.getKey());
                            sb.append("=");
                            sb.append(sp[i]);
                        }
                    }
                } else {
                    sb.append(entry.getValue());
                }
            }
            sb.append(LINE_SEPARATOR);
        }
    }

    private void appendString(StringBuilder sb, String key, String value) {
        sb.append(key);
        sb.append(": ");
        sb.append(value);
        sb.append(LINE_SEPARATOR);
    }

    private void appendUserEvent(StringBuilder sb, UserEvent event) {
        Class<?> clazz = event.getClass();
        String className = clazz.getName();
        String eventType = className.substring(className.lastIndexOf(46) + 1).toLowerCase(Locale.ENGLISH);
        if (eventType.endsWith("event")) {
            eventType = eventType.substring(0, eventType.length() - "event".length());
        }
        this.appendString(sb, "UserEvent", eventType);
    }

    private void appendGetters(StringBuilder sb, Object action, Map<String, Method> getters) {
        for (Map.Entry<String, Method> entry : getters.entrySet()) {
            Object value;
            String name = entry.getKey();
            Method getter = entry.getValue();
            if (this.membersToIgnore.contains(name)) continue;
            try {
                value = getter.invoke(action, new Object[0]);
            }
            catch (Exception ex) {
                this.logger.error("Unable to retrieve property '" + name + "' of " + action.getClass(), ex);
                continue;
            }
            if (value == null || value instanceof Class) continue;
            String mappedName = ActionBuilderImpl.mapToAsterisk(getter);
            if (value instanceof Map) {
                this.appendMap(sb, mappedName, (Map)value);
                continue;
            }
            if (value instanceof String) {
                this.appendString(sb, mappedName, (String)value);
                continue;
            }
            this.appendString(sb, mappedName, value.toString());
        }
    }

    private static String mapToAsterisk(Method getter) {
        AsteriskMapping annotation = getter.getAnnotation(AsteriskMapping.class);
        if (annotation != null) {
            return annotation.value();
        }
        String setterName = ActionBuilderImpl.determineSetterName(getter.getName());
        try {
            Method setter = getter.getDeclaringClass().getDeclaredMethod(setterName, getter.getReturnType());
            annotation = setter.getAnnotation(AsteriskMapping.class);
            if (annotation != null) {
                return annotation.value();
            }
        }
        catch (NoSuchMethodException setter) {
            // empty catch block
        }
        String fieldName = ActionBuilderImpl.determineFieldName(getter.getName());
        try {
            Field field = getter.getDeclaringClass().getDeclaredField(fieldName);
            annotation = field.getAnnotation(AsteriskMapping.class);
            if (annotation != null) {
                return annotation.value();
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return fieldName.toLowerCase(Locale.US);
    }

    static String determineSetterName(String getterName) {
        if (getterName.startsWith("get")) {
            return "set" + getterName.substring(3);
        }
        if (getterName.startsWith("is")) {
            return "set" + getterName.substring(2);
        }
        throw new IllegalArgumentException("Getter '" + getterName + "' doesn't start with either 'get' or 'is'");
    }

    static String determineFieldName(String accessorName) {
        if (accessorName.startsWith("get")) {
            return ActionBuilderImpl.lcFirst(accessorName.substring(3));
        }
        if (accessorName.startsWith("is")) {
            return ActionBuilderImpl.lcFirst(accessorName.substring(2));
        }
        if (accessorName.startsWith("set")) {
            return ActionBuilderImpl.lcFirst(accessorName.substring(3));
        }
        throw new IllegalArgumentException("Accessor '" + accessorName + "' doesn't start with either 'get', 'is' or 'set'");
    }

    private static String lcFirst(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + (s.length() == 1 ? "" : s.substring(1));
    }
}

