/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.internal.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Set;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.pbx.asterisk.wrap.events.ResponseEvent;
import org.asteriskjava.pbx.asterisk.wrap.response.CommandResponse;
import org.asteriskjava.pbx.asterisk.wrap.response.ManagerError;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;

public class CoherentEventFactory {
    private static final Log logger = LogFactory.getLog(CoherentEventFactory.class);
    static Hashtable<Class<ManagerEvent>, Class<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> mapEvents = new Hashtable();
    static Hashtable<Class<? extends org.asteriskjava.manager.event.ResponseEvent>, Class<? extends ResponseEvent>> mapResponses = new Hashtable();

    public static Class<? extends org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> getShadowEvent(ManagerEvent event) {
        Class<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> result = mapEvents.get(event.getClass());
        if (result == null) {
            Class<? extends ResponseEvent> response = mapResponses.get(event.getClass());
            result = response;
        }
        return result;
    }

    public static org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent build(ManagerEvent event) {
        org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent iEvent = null;
        Class<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> target = null;
        target = event instanceof org.asteriskjava.manager.event.ResponseEvent ? mapResponses.get(event.getClass()) : mapEvents.get(event.getClass());
        if (target == null) {
            logger.warn("The given event " + event.getClass().getName() + " is not supported ");
        } else {
            try {
                iEvent = target.getDeclaredConstructor(event.getClass()).newInstance(event);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error(e, e);
            }
        }
        return iEvent;
    }

    public static ResponseEvent build(org.asteriskjava.manager.event.ResponseEvent event) {
        ResponseEvent response = null;
        Class<? extends ResponseEvent> target = mapResponses.get(event.getClass());
        if (target == null) {
            logger.warn("The given event " + event.getClass().getName() + " is not supported ");
        } else {
            try {
                Constructor<? extends ResponseEvent> declaredConstructor = target.getDeclaredConstructor(event.getClass());
                response = declaredConstructor.newInstance(event);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error(e, e);
            }
        }
        return response;
    }

    public static org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse build(ManagerResponse response) {
        org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse result = response instanceof org.asteriskjava.manager.response.CommandResponse ? new CommandResponse(response) : (response instanceof org.asteriskjava.manager.response.ManagerError ? new ManagerError(response) : new org.asteriskjava.pbx.asterisk.wrap.response.ManagerResponse(response));
        return result;
    }

    public static ManagerAction build(org.asteriskjava.pbx.asterisk.wrap.actions.ManagerAction action) {
        ManagerAction result = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Action " + action);
        }
        result = action.getAJAction();
        return result;
    }

    static {
        Set<Class<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent>> knownClasses = ReflectionUtil.loadClasses("org.asteriskjava.pbx.asterisk.wrap.events", org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent.class);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (Class<org.asteriskjava.pbx.asterisk.wrap.events.ManagerEvent> known : knownClasses) {
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass("org.asteriskjava.manager.event." + known.getSimpleName());
                if (!Modifier.isAbstract(clazz.getModifiers())) {
                    if (known.getConstructor(clazz) != null) {
                        if (ResponseEvent.class.isAssignableFrom(known)) {
                            mapResponses.put(clazz, known);
                            logger.info("Response Event Added " + clazz + " --> " + known);
                            continue;
                        }
                        mapEvents.put(clazz, known);
                        logger.info("Manager Event Added " + clazz + " --> " + known);
                        continue;
                    }
                    logger.warn("Skipping class " + clazz + " it doesn't have a public constructor with one arg of type " + known);
                    continue;
                }
                logger.info("Skipping abstract class " + clazz);
            }
            catch (ClassNotFoundException e) {
                logger.error(e, e);
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                logger.error(clazz.getCanonicalName() + " doesn't have an appropriate event constructor");
            }
            catch (SecurityException e) {
                logger.error(e, e);
            }
        }
        mapResponses.put(org.asteriskjava.manager.event.ResponseEvent.class, ResponseEvent.class);
    }
}

