/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicLong;
import org.asteriskjava.lock.LockableSet;
import org.asteriskjava.lock.Locker;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.PingAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class PingThread
extends Thread {
    private static final long DEFAULT_INTERVAL = 20000L;
    private static final long DEFAULT_TIMEOUT = 0L;
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private final Log logger = LogFactory.getLog(this.getClass());
    private long interval = 20000L;
    private long timeout = 0L;
    private volatile boolean die = false;
    private final LockableSet<ManagerConnection> connections = new LockableSet(new HashSet());

    public PingThread() {
        long id = idCounter.getAndIncrement();
        this.setName("Asterisk-Java Ping-" + id);
        this.setDaemon(true);
    }

    public PingThread(ManagerConnection connection) {
        this();
        this.connections.add(connection);
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void addConnection(ManagerConnection connection) {
        try (Locker.LockCloser closer = this.connections.withLock();){
            this.connections.add(connection);
        }
    }

    public void removeConnection(ManagerConnection connection) {
        try (Locker.LockCloser closer = this.connections.withLock();){
            this.connections.remove(connection);
        }
    }

    public void die() {
        this.die = true;
        this.interrupt();
    }

    @Override
    public void run() {
        while (!this.die) {
            try {
                PingThread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.die) break;
            Locker.LockCloser closer = this.connections.withLock();
            Throwable throwable = null;
            try {
                for (ManagerConnection c : this.connections) {
                    if (c.getState() != ManagerConnectionState.CONNECTED) continue;
                    this.ping(c);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closer == null) continue;
                if (throwable != null) {
                    try {
                        closer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                closer.close();
            }
        }
    }

    protected void ping(ManagerConnection c) {
        try {
            if (this.timeout <= 0L) {
                c.sendAction((ManagerAction)new PingAction(), null);
            } else {
                ManagerResponse response = c.sendAction((ManagerAction)new PingAction(), this.timeout);
                this.logger.debug("Ping response '" + response + "' for " + c.toString());
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception on sending Ping to " + c.toString(), e);
        }
    }
}

